using System;
using System.Collections.Generic;
using System.Linq;

public class Resenje
{
    public class Jarbol
    {
        public long X { get; set; }
        public long H { get; set; }
        public int OriginalniIndeks { get; set; }
    }

    public static void Pokreni()
    {
        if (!int.TryParse(Console.ReadLine(), out int n)) return;

        var xKoordinate = Array.ConvertAll(Console.ReadLine().Split(' '), long.Parse);
        var hVisine = Array.ConvertAll(Console.ReadLine().Split(' '), long.Parse);

        var jarboli = new Jarbol[n];
        for (int i = 0; i < n; i++)
        {
            jarboli[i] = new Jarbol { X = xKoordinate[i], H = hVisine[i], OriginalniIndeks = i };
        }

        Array.Sort(jarboli, (a, b) => a.X.CompareTo(b.X));

        var rezultati = new long[n];
        for (int i = 0; i < n; i++)
        {
            rezultati[i] = -1;
        }

        var stekL = new Stack<int>();

        for (int k = 0; k < n; k++)
        {
            var jarbolK = jarboli[k];
            long sumaK = jarbolK.X + jarbolK.H;

            while (stekL.Count > 0)
            {
                var jarbolI = jarboli[stekL.Peek()];
                long sumaI = jarbolI.X + jarbolI.H;

                if (sumaI <= sumaK)
                {
                    stekL.Pop();
                }
                else
                {
                    break;
                }
            }

            if (stekL.Count > 0)
            {
                var najboljiJarbolI = jarboli[stekL.Peek()];
                long sumaI = najboljiJarbolI.X + najboljiJarbolI.H;

                long udaljenostL = sumaI - sumaK;

                if (rezultati[jarbolK.OriginalniIndeks] == -1 || udaljenostL < rezultati[jarbolK.OriginalniIndeks])
                {
                    rezultati[jarbolK.OriginalniIndeks] = udaljenostL;
                }
            }

            stekL.Push(k);
        }

        var stekR = new Stack<int>();

        for (int k = n - 1; k >= 0; k--)
        {
            var jarbolK = jarboli[k];
            long razlikaK = jarbolK.X - jarbolK.H;

            while (stekR.Count > 0)
            {
                var jarbolI = jarboli[stekR.Peek()];
                long razlikaI = jarbolI.X - jarbolI.H;

                if (razlikaI >= razlikaK)
                {
                    stekR.Pop();
                }
                else
                {
                    break;
                }
            }

            if (stekR.Count > 0)
            {
                var najboljiJarbolI = jarboli[stekR.Peek()];
                long razlikaI = najboljiJarbolI.X - najboljiJarbolI.H;

                long udaljenostR = razlikaK - razlikaI;

                if (rezultati[jarbolK.OriginalniIndeks] == -1 || udaljenostR < rezultati[jarbolK.OriginalniIndeks])
                {
                    rezultati[jarbolK.OriginalniIndeks] = udaljenostR;
                }
            }

            stekR.Push(k);
        }

        foreach (var res in rezultati)
        {
            Console.WriteLine(res);
        }
    }
}